function onInit()
end

function onThink()
end


function onPrimaryAttack( )

if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
-- The Nadebase is the actual grenade
Nadebase = _EntCreate( "prop_physics" );
-- The iSmoke is the smoke that comes from the grenade
iSmoke = _EntCreate( "env_smoketrail" );


_EntPrecacheModel( "models/weapons/w_eq_flashbang.mdl" );
_EntSetModel( Nadebase,"models/weapons/w_eq_flashbang.mdl" );

_PhysSetMass( Nadebase,"750" )


_EntSetAng( Nadebase, _PlayerGetShootAng( Owner ) );

_EntSetPos( Nadebase, _PlayerGetShootPos( Owner ) );
_EntSetPos( iSmoke, _EntGetPos( Nadebase ) );

_EntFire( Nadebase, "Alpha", "255", 0 )

_EntSetKeyValue( Nadebase,"rendermode",1 )
_EntSetKeyValue( iSmoke,"smokesprite","sprites/whitepuff.spr" )
_EntSetKeyValue( iSmoke,"firesprite","sprites/firetrail.spr" )

-- Change these if you want to change the size of the smoke.
-- Spawnradius is the size of the smoke when it begins smoking.
-- Endsize is the size that the smoke ends at.
_EntSetKeyValue( iSmoke,"spawnradius",105 )
_EntSetKeyValue( iSmoke,"endsize",175 )

-- Change this value to change the color of the smoke. Pretty self-explanatory.
-- Just imagine- red smoke changing to blue!
_EntSetKeyValue( iSmoke,"startcolor","225 225 225" )
_EntSetKeyValue( iSmoke,"endcolor","255 255 255" )

-- This is how long the smoke lasts
_EntSetKeyValue( iSmoke,"lifetime","20.0" )

-- This is how much smoke is made, I think. Probably best to leave it.
_EntSetKeyValue( iSmoke,"spawnrate","20" )

-- This is the opacity, or transparency of the smoke. Higher is denser.
_EntSetKeyValue( iSmoke,"opacity","0.85" )

_EntEmitSound( Nadebase, "weapons/smokegrenade/sg_explode.wav" )


local vVelocity = vecMul( _PlayerGetShootAng( Owner ), vector3(1000, 1000, 1000) );


_EntFire( Nadebase,"Kill","1", 25 )
_EntFire( Nadebase,"sethealth","99999",0 )

_EntSetParent( iSmoke,Nadebase )

_EntSpawn( Nadebase );
_EntSpawn( iSmoke);

_PhysApplyForce(Nadebase, vVelocity)
_PhysEnableGravity( Nadebase,true )


	end




function onSecondaryAttack()
return false;
end

function onReload( )
	return false;
end

function getWeaponSwapHands()
	return false;	
end

function getWeaponFOV()
	return 70;	
end


function getWeaponSlot()
	return 4;	
end

function getWeaponSlotPos()
	return 5;	
end

function getFiresUnderwater()
	return false;
end

function getReloadsSingly()
	return false;
end

function getDamage()
	return 0;
end

function getPrimaryShotDelay()
	return 1.0;
end

function getSecondaryShotDelay()
	return 0;
end

function getPrimaryIsAutomatic()
	return false;
end

function getSecondaryIsAutomatic()
	return false;
end

function getPrimaryAmmoType()
	return "grenade";
end

function getSecondaryAmmoType()
	return "none";
end

function getMaxClipPrimary()
	return -1;
end

function getMaxClipSecondary()
	return 0;
end

function getDefClipPrimary()
	return 1;
end


function getDefClipSecondary()
	return 0;
end

function getPrimaryScriptOverride()
	return 1;
end

function getSecondaryScriptOverride()
	return 3;
end

function getBulletSpread()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewKick()
	return vector3( 0, 0.0, 0.0);
end

function getViewKickRandom()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewModel( )
	return "models/weapons/v_eq_flashbang.mdl";
end

function getWorldModel( )
	return "models/weapons/w_eq_flashbang.mdl";

end

function getClassName()
	return "Smokegrenade";
end

function getAnimPrefix()
	return "grenade";
end

function getPrintName()
	return "Smoke Grenade";
end